## 🔥DeepSeek 小白快速上手指南

## 第一章：准备篇

### 1.1 三分钟创建你的AI伙伴

DeepSeek官方提供的是满血版的AI，虽然它是开源的，但是官方在开源版本上对于使用进行优化，相比起来效果最好，所以这也是最推荐的使用方法。    

官方提供了两种使用渠道，分别是网页版和手机版，**完全免费**。

**官方网页版**

访问链接：https://chat.deepseek.com/，可以在任何设备和浏览器打开，手机和电脑等都没有问题。

之前从未登录过的用户需要进行登陆，使用手机号、微信或者邮箱登陆即可。

![img](https://pic.yupi.icu/yuyi/1739498392384-e7484fdb-d7bb-4b43-b7f4-30354cad446a.png)

然后点击“开始对话”就可以使用。    

![img](https://pic.yupi.icu/yuyi/1739498467461-a1cc8752-0769-48c5-b6ce-5058f26b6bfa.png)

不过需要注意一点儿，那就是如何选择V3还是R1模型，可以参考下图。

![img](https://pic.yupi.icu/yuyi/1739498992024-711c13f6-11a1-4ee1-a836-54c5268fac31.png)

也可以在手机自带的应用商城中，搜索DeepSeek，点击下载安装即可。    

![img](https://pic.yupi.icu/yuyi/1739499875545-fafd7d86-3809-4406-a76f-d264618d1f95.png)    

 

手机版的使用和电脑版基本一样，根据需要是否激活R1即可。

![img](https://pic.yupi.icu/yuyi/1739433741847-5f557647-62a8-45a2-8845-943d43ae86c6.jpeg)

### 1.2 认识你的AI控制台

**核心界面全解析：**

1. **对话输入框**：像发微信一样打字，但记得按 `Enter` 发送（而不是微信的「发送」按钮，网页版按shift回车来换行，直接按回车是发送。）
2. **历史记录栏**：左侧列表显示所有对话，可右键「重命名对话」，方便查找（例如改为「毕业论文辅助」）
3. **功能工具栏**：

- **格式按钮**：插入代码块、表格、公式的快捷键
- ⏳ **记忆库**：点击星标保存重要信息（相当于AI的记事本）
- ⚙ **设置**：调整响应速度/创意程度（新手建议保持默认）

**实时演练：**

1. 输入 **「你好，请做自我介绍」**，观察 AI 响应
2. 尝试点击「代码块」图标，输入 **「请用Python打印爱心图案」**
3. 将当前对话重命名为 **「测试练习」**

------

## 第二章：基础对话篇（像交朋友一样学交流）

### 2.1 有效提问的五个黄金法则

1. **明确需求**

- ❌ **错误示例**：「帮我写点东西」
- ✅ **正确示例**：「我需要一封求职邮件，应聘新媒体运营岗位，强调3年公众号运营经验」
2.  **提供背景**
- ❌ **错误示例**：「分析这个数据」
- ✅ **正确示例**：「这是一家奶茶店过去三个月的销售数据，请分析周末和工作日的销量差异（附CSV数据）」
3. **指定格式**
- ❌ **错误示例**：「给几个营销方案」
- ✅ **正确示例**：「请用表格形式列出三种情人节咖啡店促销方案，包含成本预估和预期效果」
4. **控制长度**
- ❌ **错误示例**：「详细说明」
- ✅ **正确示例**：「请用200字以内解释区块链技术，让完全不懂技术的老人能听懂」
5. **及时纠正**
- **当回答不满意时，可以这样调整指令：**

  - 「这个方案成本太高，请提供预算控制在500元以内的版本」
  - 「请用更正式的语气重写第二段」

### 2.2 新手必学的魔法指令

**基础指令集**：

1. `/续写` ：当回答中断时自动继续生成
2. `/简化` ：将复杂内容转换成大白话
3. `/示例` ：要求展示实际案例（特别是写代码时）
4. `/步骤` ：让AI分步骤指导操作流程
5. `/检查` ：帮你发现文档中的错误

**场景演练：**

- 输入 `/步骤 如何用手机拍摄美食照片`，观察分步指导
- 输入 `请解释量子计算，然后 /简化`，对比前后差异

------

## 第三章：效率飞跃篇（文件处理与复杂任务）

### 3.1 五分钟学会文档分析

**操作流程：**

1. 点击「回形针」图标上传文件（支持PDF/Word/TXT）
2. 输入具体指令，例如：

- **「总结这份年报的三个核心要点」**
- **「提取合同中的责任条款制成表格」**

**进阶技巧：**

- **对比分析**：「对比文档A和文档B的市场策略差异」
- **数据提取**：「从实验报告中整理所有温度数据」

**避坑指南：**

- **超过50页的文档** 建议先拆分处理
- **扫描版PDF** 需确保文字可复制

------

### 3.2 让AI帮你写代码

**万能模板示例：**

```plain
【语言】Python
【功能】自动下载网页图片
【要求】
- 处理SSL证书错误
- 显示下载进度条
- 保存到指定文件夹
```

**执行策略：**

1. 先让AI生成代码
2. 要求添加注释说明
3. 请求逐行解释关键代码段
4. 遇到报错直接粘贴错误信息

### 3.3 复杂任务自动化

**示例：批量Excel数据处理**

指令示例：

```plain
请读取这份Excel文件，计算每个销售员过去三个月的平均销售额，并按从高到低排序
```

**进阶玩法：**

- **数据清理**：「删除缺失值超过50%的行」
- **格式转换**：「把JSON文件转成CSV」
- **多文件合并**：「合并这些10个Excel文件的销量数据，按时间排序」



> 来源：https://zhuanlan.zhihu.com/p/21910721060
>
> https://news.qq.com/rain/a/20250202A0213S00